/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphSync;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalPropagator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class TrackPropagator {
    public static void onRailRemoved(class_1936 reader, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        Collection<TrackNodeLocation.DiscoveredLocation> ends = track.getConnected((class_1922)reader, pos, state, false, null);
        GlobalRailwayManager manager = Create.RAILWAYS;
        TrackGraphSync sync = manager.sync;
        for (TrackNodeLocation.DiscoveredLocation discoveredLocation : ends) {
            List<TrackGraph> intersecting = manager.getGraphs(reader, discoveredLocation);
            for (TrackGraph foundGraph : intersecting) {
                TrackNode removedNode = foundGraph.locateNode(discoveredLocation);
                if (removedNode == null) continue;
                foundGraph.removeNode(reader, discoveredLocation);
                sync.nodeRemoved(foundGraph, removedNode);
                if (!foundGraph.isEmpty()) continue;
                manager.removeGraphAndGroup(foundGraph);
                sync.graphRemoved(foundGraph);
            }
        }
        HashSet<class_2338> positionsToUpdate = new HashSet<class_2338>();
        for (TrackNodeLocation.DiscoveredLocation removedEnd : ends) {
            positionsToUpdate.addAll(removedEnd.allAdjacent());
        }
        HashSet<TrackGraph> hashSet = new HashSet<TrackGraph>();
        for (class_2338 blockPos : positionsToUpdate) {
            TrackGraph onRailAdded;
            if (blockPos.equals((Object)pos) || (onRailAdded = TrackPropagator.onRailAdded(reader, blockPos, reader.method_8320(blockPos))) == null) continue;
            hashSet.add(onRailAdded);
        }
        for (TrackGraph railGraph : hashSet) {
            manager.updateSplitGraph(reader, railGraph);
        }
        manager.markTracksDirty();
    }

    public static TrackGraph onRailAdded(class_1936 reader, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return null;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        GlobalRailwayManager manager = Create.RAILWAYS;
        TrackGraphSync sync = manager.sync;
        ArrayList<FrontierEntry> frontier = new ArrayList<FrontierEntry>();
        HashSet<TrackNodeLocation.DiscoveredLocation> visited = new HashSet<TrackNodeLocation.DiscoveredLocation>();
        HashSet<TrackGraph> connectedGraphs = new HashSet<TrackGraph>();
        TrackPropagator.addInitialEndsOf(reader, pos, state, track, frontier, false);
        int emergencyExit = 1000;
        while (!frontier.isEmpty() && emergencyExit-- != 0) {
            FrontierEntry entry = (FrontierEntry)frontier.remove(0);
            List<TrackGraph> intersecting = manager.getGraphs(reader, entry.currentNode);
            for (TrackGraph graph : intersecting) {
                TrackNode node = graph.locateNode(entry.currentNode);
                graph.removeNode(reader, entry.currentNode);
                sync.nodeRemoved(graph, node);
                connectedGraphs.add(graph);
            }
            if (!intersecting.isEmpty()) continue;
            Collection<TrackNodeLocation.DiscoveredLocation> ends = ITrackBlock.walkConnectedTracks((class_1922)reader, entry.currentNode, false);
            if (entry.prevNode != null) {
                ends.remove((Object)entry.prevNode);
            }
            TrackPropagator.continueSearch(frontier, visited, entry, ends);
        }
        frontier.clear();
        visited.clear();
        TrackGraph graph = null;
        Iterator iterator = connectedGraphs.iterator();
        while (iterator.hasNext()) {
            TrackGraph railGraph = (TrackGraph)iterator.next();
            if (!railGraph.isEmpty() || connectedGraphs.size() == 1) continue;
            manager.removeGraphAndGroup(railGraph);
            sync.graphRemoved(railGraph);
            iterator.remove();
        }
        if (connectedGraphs.size() > 1) {
            for (TrackGraph other : connectedGraphs) {
                if (graph == null) {
                    graph = other;
                    continue;
                }
                other.transferAll(graph);
                manager.removeGraphAndGroup(other);
                sync.graphRemoved(other);
            }
        } else if (connectedGraphs.size() == 1) {
            graph = (TrackGraph)connectedGraphs.stream().findFirst().get();
        } else {
            graph = new TrackGraph();
            manager.putGraphWithDefaultGroup(graph);
        }
        TrackNodeLocation.DiscoveredLocation startNode = null;
        TrackPropagator.addInitialEndsOf(reader, pos, state, track, frontier, true);
        emergencyExit = 1000;
        while (!frontier.isEmpty() && emergencyExit-- != 0) {
            boolean first;
            FrontierEntry entry = (FrontierEntry)frontier.remove(0);
            Collection<TrackNodeLocation.DiscoveredLocation> ends = ITrackBlock.walkConnectedTracks((class_1922)reader, entry.currentNode, false);
            boolean bl = first = entry.prevNode == null;
            if (!first) {
                ends.remove((Object)entry.prevNode);
            }
            if (TrackPropagator.isValidGraphNodeLocation(entry.currentNode, ends, first)) {
                startNode = entry.currentNode;
                break;
            }
            TrackPropagator.continueSearch(frontier, visited, entry, ends);
        }
        frontier.clear();
        HashSet<TrackNode> addedNodes = new HashSet<TrackNode>();
        graph.createNodeIfAbsent(startNode);
        frontier.add(new FrontierEntry(startNode, null, startNode));
        emergencyExit = 1000;
        while (!frontier.isEmpty() && emergencyExit-- != 0) {
            boolean first;
            FrontierEntry entry = (FrontierEntry)frontier.remove(0);
            TrackNodeLocation.DiscoveredLocation parentNode = entry.parentNode;
            Collection<TrackNodeLocation.DiscoveredLocation> ends = ITrackBlock.walkConnectedTracks((class_1922)reader, entry.currentNode, false);
            boolean bl = first = entry.prevNode == null;
            if (!first) {
                ends.remove((Object)entry.prevNode);
            }
            if (TrackPropagator.isValidGraphNodeLocation(entry.currentNode, ends, first) && entry.currentNode != startNode) {
                boolean nodeIsNew = graph.createNodeIfAbsent(entry.currentNode);
                graph.connectNodes(reader, parentNode, entry.currentNode, entry.currentNode.getTurn());
                addedNodes.add(graph.locateNode(entry.currentNode));
                parentNode = entry.currentNode;
                if (!nodeIsNew) continue;
            }
            TrackPropagator.continueSearchWithParent(frontier, entry, parentNode, ends);
        }
        manager.markTracksDirty();
        for (TrackNode trackNode : addedNodes) {
            SignalPropagator.notifySignalsOfNewNode(graph, trackNode);
        }
        return graph;
    }

    private static void addInitialEndsOf(class_1936 reader, class_2338 pos, class_2680 state, ITrackBlock track, List<FrontierEntry> frontier, boolean ignoreTurns) {
        for (TrackNodeLocation.DiscoveredLocation initial : track.getConnected((class_1922)reader, pos, state, ignoreTurns, null)) {
            frontier.add(new FrontierEntry(null, null, initial));
        }
    }

    private static void continueSearch(List<FrontierEntry> frontier, Set<TrackNodeLocation.DiscoveredLocation> visited, FrontierEntry entry, Collection<TrackNodeLocation.DiscoveredLocation> ends) {
        for (TrackNodeLocation.DiscoveredLocation location : ends) {
            if (!visited.add(location)) continue;
            frontier.add(new FrontierEntry(null, entry.currentNode, location));
        }
    }

    private static void continueSearchWithParent(List<FrontierEntry> frontier, FrontierEntry entry, TrackNodeLocation.DiscoveredLocation parentNode, Collection<TrackNodeLocation.DiscoveredLocation> ends) {
        for (TrackNodeLocation.DiscoveredLocation location : ends) {
            frontier.add(new FrontierEntry(parentNode, entry.currentNode, location));
        }
    }

    public static boolean isValidGraphNodeLocation(TrackNodeLocation.DiscoveredLocation location, Collection<TrackNodeLocation.DiscoveredLocation> next, boolean first) {
        boolean centeredZ;
        int size = next.size() - (first ? 1 : 0);
        if (size != 1) {
            return true;
        }
        if (location.shouldForceNode()) {
            return true;
        }
        if (next.stream().anyMatch(TrackNodeLocation.DiscoveredLocation::shouldForceNode)) {
            return true;
        }
        class_243 direction = location.direction;
        if (direction != null && next.stream().anyMatch(dl -> dl.notInLineWith(direction))) {
            return true;
        }
        class_243 vec = location.getLocation();
        boolean centeredX = !class_3532.method_20390((double)vec.field_1352, (double)Math.round(vec.field_1352));
        boolean bl = centeredZ = !class_3532.method_20390((double)vec.field_1350, (double)Math.round(vec.field_1350));
        if (centeredX && !centeredZ) {
            return (int)Math.round(vec.field_1350) % 16 == 0;
        }
        return (int)Math.round(vec.field_1352) % 16 == 0;
    }

    static class FrontierEntry {
        TrackNodeLocation.DiscoveredLocation prevNode;
        TrackNodeLocation.DiscoveredLocation currentNode;
        TrackNodeLocation.DiscoveredLocation parentNode;

        public FrontierEntry(TrackNodeLocation.DiscoveredLocation parent, TrackNodeLocation.DiscoveredLocation previousNode, TrackNodeLocation.DiscoveredLocation location) {
            this.parentNode = parent;
            this.prevNode = previousNode;
            this.currentNode = location;
        }
    }
}

